(
	-- Color Correction Texture: FULL IMPLEMENTATION

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"85518d3a-34a4-4967-9296-c279811bbf80" 
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode

			if (mtl.map != undefined) do
			(
				append res #("input",     mtl.map, out) 
				append res #("alpha",     mtl.map, "alpha") 
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("input",     mtl.color) 
			append res #("alpha",     mtl.color.a/255.0) 

			append res #("RewireR", mtl.rewireR) 
			append res #("RewireG", mtl.rewireG) 
			append res #("RewireB", mtl.rewireB) 
			append res #("RewireA", mtl.rewireA) 

			append res #("hueShift", mtl.hueShift / 360.0) 
			append res #("saturation", 1.0 + (mtl.saturation / 100.0)) 

			append res #("tintHue", mtl.tint.h / 255.0)
			append res #("tintStrength", mtl.tintStrength / 100.0)  

			if (mtl.lightnessmode == 0) then
			(
				-- Regular mode

				local gain = 1.0 + mtl.contrast / 100.0;
				local lift = (mtl.brightness / 100.0) - 0.5 * (gain - 1.0)

				append res #("gainRGB", gain )
				append res #("liftRGB", lift )
				append res #("gammaRGB", 1.0 )
				append res #("pivotRGB", 1.0 )
				append res #("EnableR", false )
				append res #("EnableG", false )
				append res #("EnableB", false )
			)
			else
			(
				local gain = 1.0
				local lift = 0.0

				-- Gain math for Global
				gain = mtl.gainRGB / 100.0
				if (mtl.exposureMode == 1) do gain = pow 2.0 gain
				if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
				append res #("gainRGB", gain )
				append res #("liftRGB", mtl.liftRGB)
				append res #("gammaRGB", 1.0 / mtl.gammaRGB )
				append res #("pivotRGB", mtl.pivotRGB )

				if (mtl.EnableR) do (
					-- Gain math for red override
					gain = mtl.gainR / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainR", gain )
					append res #("liftR", mtl.liftR )
					append res #("gammaR", 1.0 / mtl.gammaR )
					append res #("pivotR", mtl.pivotR )
				)

				if (mtl.EnableG) do (
					-- Gain math for green override
					gain = mtl.gainG / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainG", gain )
					append res #("liftG", mtl.liftG )
					append res #("gammaG", 1.0 / mtl.gammaG )
					append res #("pivotG", mtl.pivotG )
				)

				if (mtl.EnableB) do (
					-- Gain math for blue override
					gain = mtl.gainB / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainB", gain )
					append res #("liftB", mtl.liftB )
					append res #("gammaB", 1.0 / mtl.gammaB )
					append res #("pivotB", mtl.pivotB )
				)

				append res #("EnableR", mtl.EnableR)
				append res #("EnableG", mtl.EnableG)
				append res #("EnableB", mtl.EnableB)
			)			

 			res
		)
	)

	AMGData()
)